% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findRhoInterval.R
\name{findRhoInterval}
\alias{findRhoInterval}
\title{Find an interval contraining the rho parameter for a non linear kernel}
\usage{
findRhoInterval(tZ, rho_init = seq(0.01, 20, length = 300) * nrow(tZ),
  kernel = c("gaussian", "poly"), d = NA, rate_range = c(1.5, 4),
  pca_thres = 0.9, warning_suppress = TRUE)
}
\arguments{
\item{tZ}{a \code{P x N} matrix of genomic covariates (i.e., the usual data array Z transposed)}

\item{rho_init}{an initial large range of possible rhos, which will be considered to see if they are
reasonable tuning parameters for the kernel. Default is \code{seq(0.01, 20, length=300)*P}. See Details.}

\item{kernel}{character string specifying a nonlinear kernel. Currently supported options are:
\code{"gaussian"} or \code{"poly"}}

\item{d}{if \code{kernel} is \code{"poly"}, the polynomial power (e.g. d=2 for quadratic kernel).
Default is \code{NA}.}

\item{rate_range}{a vector of length 2 indicating the range of alpha in the paper. Default is \code{c(1.5,4)}.}

\item{pca_thres}{a number between \code{0} and \code{1} giving the threshold to be used for PCA.
Default is \code{0.9}. If \code{NULL}, no PCA is performed.}

\item{warning_suppress}{logical flag. Indicating wether the warnings should be suppress during
the linear model fitting step. Default is \code{TRUE}. See details.}
}
\value{
an upper and lower bound to look for rho
}
\description{
Find an interval contraining the rho parameter for a non linear kernel
}
\details{
This function will print \code{rho_init} range and the range of valid tuning parameters.
If that range butts up against either the upper or lower bound of rho_init, you can rerun this function
with a bigger \code{rho_init}.

Finding the right tuning parameters includes a step of fitting a linear model which can fail
because some tuning parameters yield only one eigenvector. We want to eliminate those tuning parameters,
so this is OK. However, in case one want to suppress (numerous) annoying warning messages, use the
\code{warning_suppress} argument.
}
\examples{

## First generate some Data
feat_m_fun <- function(X){
 sin(X[,1]+X[,2]^2)-1
}
feat_d_fun <-  function(X){
 (X[,4]-X[,5])^2/8
}
mydata <- sim_SCR_data(data_size = 400, ncol_gene_mat = 20, feat_m = feat_m_fun,
                      feat_d = feat_d_fun, mu_cen = 30, cov=0.5)

#initial range
ind_gene <- c(7:ncol(mydata))
my_rho_init <- seq(0.01, 20, length=300)*length(ind_gene)
range(my_rho_init)

\dontrun{
# compute the interval for rho
rho_set <- findRhoInterval(tZ=t(mydata[,ind_gene]), rho_init = my_rho_init, kernel="gaussian")
rho_set
range(my_rho_init) # good to check that the interval produced here is strictly contained in rho_init
# otherwise, expand rho.init and rerun

#rhos <- exp(seq(log(rho_set[1]),log(rho_set[2]), length=50))
}
}

