% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoped.R
\name{remove-keys-scoped}
\alias{remove-keys-scoped}
\alias{remove_keys_all}
\alias{remove_keys_if}
\alias{remove_keys_at}
\title{Remove selection of keys}
\usage{
remove_keys_all(.tbl, ..., .unkey = FALSE)

remove_keys_if(.tbl, .predicate, ..., .unkey = FALSE)

remove_keys_at(.tbl, .vars, ..., .unkey = FALSE)
}
\arguments{
\item{.tbl}{Reference data frame.}

\item{...}{Parameter for \link[dplyr:scoped]{scoped} functions.}

\item{.unkey}{Whether to \code{\link[=unkey]{unkey()}} \code{.tbl} in case there are no keys left.}

\item{.predicate}{Parameter for \link[dplyr:scoped]{scoped} functions.}

\item{.vars}{Parameter for \link[dplyr:scoped]{scoped} functions.}
}
\description{
These functions remove selection of keys using corresponding
\link[dplyr:select_all]{scoped variant} of \link[dplyr:select]{select}. \code{.funs}
argument is removed because of its redundancy.
}
\examples{
df <- mtcars \%>\% dplyr::as_tibble() \%>\% key_by(vs, am, disp)
df \%>\% remove_keys_all()

df \%>\% remove_keys_all(.unkey = TRUE)

df \%>\% remove_keys_if(rlang::is_integerish)

df \%>\% remove_keys_at(c("vs", "am"))

}
