% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contingency_table.R
\name{contingency_table}
\alias{contingency_table}
\title{Contingency table}
\usage{
contingency_table(
  data = NULL,
  row_var_name = NULL,
  col_var_name = NULL,
  row = NULL,
  col = NULL,
  output_type = "table"
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{row_var_name}{name of the variable whose values will fill the
rows of the contingency table}

\item{col_var_name}{name of the variable whose values will fill the
columns of the contingency table}

\item{row}{a vector whose values will fill the rows of the
contingency table}

\item{col}{a vector whose values will fill the columns of the
contingency table}

\item{output_type}{If \code{output_type == "dt"} the output will be a
contingency table as a data.table object.
If \code{output_type == "table"} the output will be a contingency table
as a table object.
If \code{output_type == "df"} the output will be a contingency
table as a data.frame object.
By default, \code{output_type == "table"}.}
}
\description{
Create a contingency table that takes two variables as inputs
}
\examples{
contingency_table(
data = mtcars,
row_var_name = "am",
col_var_name = "cyl")
contingency_table(row = mtcars$cyl, col = mtcars$am)
contingency_table(mtcars, "am", "cyl", output_type = "dt")
}
