% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/floodlight_2_by_continuous.R
\name{floodlight_2_by_continuous}
\alias{floodlight_2_by_continuous}
\title{Floodlight 2 by Continuous}
\usage{
floodlight_2_by_continuous(
  data = NULL,
  iv_name = NULL,
  dv_name = NULL,
  mod_name = NULL,
  covariate_name = NULL,
  interaction_p_include = TRUE,
  iv_level_order = NULL,
  output = "reg_lines_plot",
  jitter_x_percent = 0,
  jitter_y_percent = 0,
  dot_alpha = 0.5,
  dot_size = 4,
  interaction_p_value_font_size = 8,
  jn_point_label_add = TRUE,
  jn_point_font_size = 8,
  jn_point_label_hjust = NULL,
  lines_at_mod_extremes = FALSE,
  interaction_p_vjust = -3,
  plot_margin = ggplot2::unit(c(75, 7, 7, 7), "pt"),
  legend_position = "right",
  reg_line_types = c("solid", "dashed"),
  jn_line_types = c("solid", "solid"),
  jn_line_thickness = 1.5,
  colors_for_iv = c("red", "blue"),
  sig_region_color = "green",
  sig_region_alpha = 0.08,
  nonsig_region_color = "gray",
  nonsig_region_alpha = 0.08,
  x_axis_title = NULL,
  y_axis_title = NULL,
  legend_title = NULL,
  round_decimals_int_p_value = 3,
  line_of_fit_thickness = 1,
  round_jn_point_labels = 2
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the binary independent variable}

\item{dv_name}{name of the dependent variable}

\item{mod_name}{name of the continuous moderator variable}

\item{covariate_name}{name of the variables to control for}

\item{interaction_p_include}{logical. Should the plot include a
p-value for the interaction term?}

\item{iv_level_order}{order of levels in the independent
variable for legend. By default, it will be set as levels of the
independent variable ordered using R's base function \code{sort}.}

\item{output}{type of output (default = "reg_lines_plot").
Possible inputs: "interactions_pkg_results", "simple_effects_plot",
"jn_points", "regions", "reg_lines_plot"}

\item{jitter_x_percent}{horizontally jitter dots by a percentage of the
range of x values}

\item{jitter_y_percent}{vertically jitter dots by a percentage of the
range of y values}

\item{dot_alpha}{opacity of the dots (0 = completely transparent,
1 = completely opaque). By default, \code{dot_alpha = 0.5}}

\item{dot_size}{size of the dots (default = 4)}

\item{interaction_p_value_font_size}{font size for the interaction
p value (default = 8)}

\item{jn_point_label_add}{logical. Should the labels for
Johnson-Neyman point labels be added to the plot? (default = TRUE)}

\item{jn_point_font_size}{font size for Johnson-Neyman point labels
(default = 8)}

\item{jn_point_label_hjust}{a vector of hjust values for
Johnson-Neyman point labels. By default, the hjust value will be 0.5 for
all the points.}

\item{lines_at_mod_extremes}{logical. Should vertical lines be
drawn at the observed extreme values of the moderator if those values
lie in siginificant region(s)?
(default = FALSE)}

\item{interaction_p_vjust}{By how much should the label for the
interaction p-value be adjusted vertically?
By default, \code{interaction_p_vjust = -3})}

\item{plot_margin}{margin for the plot
By default \code{plot_margin = ggplot2::unit(c(75, 7, 7, 7), "pt")}}

\item{legend_position}{position of the legend (default = "right").
If \code{legend_position = "none"}, the legend will be removed.}

\item{reg_line_types}{types of the regression lines for the two levels
of the independent variable.
By default, \code{reg_line_types = c("solid", "dashed")}}

\item{jn_line_types}{types of the lines for Johnson-Neyman points.
By default, \code{jn_line_types = c("solid", "solid")}}

\item{jn_line_thickness}{thickness of the lines at Johnson-Neyman points
(default = 1.5)}

\item{colors_for_iv}{colors for the two values of the
independent variable (default = c("red", "blue"))}

\item{sig_region_color}{color of the significant region, i.e., range(s)
of the moderator variable for which simple effect of the independent
variable on the dependent variable is statistically significant.}

\item{sig_region_alpha}{opacity for \code{sig_region_color}.
(0 = completely transparent, 1 = completely opaque).
By default, \code{sig_region_alpha = 0.08}}

\item{nonsig_region_color}{color of the non-significant region,
i.e., range(s) of the moderator variable for which simple effect of
the independent variable on the dependent variable is not
statistically significant.}

\item{nonsig_region_alpha}{opacity for \code{nonsig_region_color}.
(0 = completely transparent, 1 = completely opaque).
By default, \code{nonsig_region_alpha = 0.08}}

\item{x_axis_title}{title of the x axis. By default, it will be set
as input for \code{mod_name}. If \code{x_axis_title = FALSE}, it will
be removed.}

\item{y_axis_title}{title of the y axis. By default, it will be set
as input for \code{dv_name}. If \code{y_axis_title = FALSE}, it will
be removed.}

\item{legend_title}{title of the legend. By default, it will be set
as input for \code{iv_name}. If \code{legend_title = FALSE}, it will
be removed.}

\item{round_decimals_int_p_value}{To how many digits after the
decimal point should the p value for the interaction term be
rounded? (default = 3)}

\item{line_of_fit_thickness}{thickness of the lines of fit (default = 1)}

\item{round_jn_point_labels}{To how many digits after the
decimal point should the jn point labels be rounded? (default = 2)}
}
\description{
Conduct a floodlight analysis for 2 x Continuous design.
}
\details{
The following package(s) must be installed prior to running this function:
Package 'interactions' v1.1.1 (or possibly a higher version) by
Jacob A. Long (2020),
\url{https://cran.r-project.org/package=interactions}
See the following references:
Spiller et al. (2013) \doi{10.1509/jmr.12.0420}
Kim (2021) \doi{10.5281/zenodo.4445388}
}
\examples{
\donttest{
# typical example
floodlight_2_by_continuous(
data = mtcars,
iv_name = "am",
dv_name = "mpg",
mod_name = "qsec")
# add covariates
floodlight_2_by_continuous(
data = mtcars,
iv_name = "am",
dv_name = "mpg",
mod_name = "qsec",
covariate_name = c("cyl", "hp"))
# adjust the jn point label positions
floodlight_2_by_continuous(
data = mtcars,
iv_name = "am",
dv_name = "mpg",
mod_name = "qsec",
jn_point_label_hjust = c(1, 0))
# return regions of significance and nonsignificance
floodlight_2_by_continuous(
data = mtcars,
iv_name = "am",
dv_name = "mpg",
mod_name = "qsec",
output = "regions")
# draw lines at the extreme values of the moderator
# if they are included in the significant region
floodlight_2_by_continuous(
data = mtcars,
iv_name = "am",
dv_name = "mpg",
mod_name = "qsec",
lines_at_mod_extremes = TRUE)
}
# remove the labels for jn points
floodlight_2_by_continuous(
data = mtcars,
iv_name = "am",
dv_name = "mpg",
mod_name = "qsec",
jn_point_label_add = FALSE)
}
