% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_regression.R
\name{robust_regression}
\alias{robust_regression}
\title{Robust regression (bootstrapped regression)}
\usage{
robust_regression(
  data = NULL,
  formula = NULL,
  sigfigs = NULL,
  round_digits_after_decimal = NULL,
  iterations = 1000
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{formula}{a formula object for the regression equation}

\item{sigfigs}{number of significant digits to round to}

\item{round_digits_after_decimal}{round to nth digit after decimal
(alternative to \code{sigfigs})}

\item{iterations}{number of bootstrap samples. The default is set at 1000,
but consider increasing the number of samples to 5000, 10000, or an
even larger number, if slower handling time is not an issue.}
}
\description{
Estimate coefficients in a multiple regression model by bootstrapping.
}
\details{
The following package(s) must be installed prior to running this function:
Package 'boot' v1.3-26 (or possibly a higher version) by
Canty & Ripley (2021),
\url{https://cran.r-project.org/package=boot}
}
\examples{
\dontrun{
robust_regression(
  data = mtcars, formula = mpg ~ cyl * hp,
  iterations = 100
)
}
}
