\name{grand.table}
\alias{grand.table}
\title{Export results to a table}
\usage{
  grand.table(NR.res = NULL, NRET.res = NULL, NRETp.res =
  NULL, ET.res = NULL, rescale = TRUE, file = NULL, csv2 =
  TRUE, encoding = "CP1252", ...)
}
\arguments{
  \item{NR.res}{An object of class \code{klausuR} which was
  evaluated according to the NR scoring policy. Usual MC
  tests must be given as \code{NR.res}, too.}

  \item{NRET.res}{An object of class \code{klausuR} which
  was evaluated according to the NRET scoring policy.}

  \item{NRETp.res}{An object of class \code{klausuR} which
  was evaluated according to the NRET+ scoring policy.}

  \item{ET.res}{An object of class \code{klausuR} which was
  evaluated according to the ET scoring policy.}

  \item{rescale}{Logical, whether ET/NRET scaled results
  should be rescaled by
  \code{\link[klausuR]{nret.rescale}}.}

  \item{file}{A character string giving a file name to save
  to. If \code{NULL}, no file will be written.}

  \item{csv2}{Logical. If \code{FALSE}, \code{write.csv}
  will be used instead of \code{write.csv2}.}

  \item{encoding}{Encoding of the exported table.}

  \item{...}{Additional options for
  \code{write.csv}/\code{write.csv2}.}
}
\value{
  A data.frame.
}
\description{
  Try this function to combine results from an evaluated
  test into a matrix and export it to a table, e.g. to
  import in other software products. It can be
  particularily helpful for ET/NRET coded tests, if you
  want to compare the results of different valid scoring
  functions.
}
\note{
  For obvious reasons At least one of \code{NR.res},
  \code{NRET.res}, \code{NRETp.res} or \code{ET.res}, or
  any combination of those, must be specified.
}
\author{
  m.eik michalke \email{meik.michalke@uni-duesseldorf.de}
}
\keyword{misc}

