% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-similarity-matrix.R
\name{plotSimilarityMatrix}
\alias{plotSimilarityMatrix}
\title{Plot similarity matrix with pheatmap}
\usage{
plotSimilarityMatrix(
  X,
  y = NULL,
  clusLabels = NULL,
  colX = NULL,
  colY = NULL,
  myLegend = NULL,
  fileName = "posteriorSimilarityMatrix",
  savePNG = FALSE,
  semiSupervised = FALSE,
  showObsNames = FALSE,
  clr = FALSE,
  clc = FALSE,
  plotWidth = 500,
  plotHeight = 450
)
}
\arguments{
\item{X}{Similarity matrix.}

\item{y}{Vector}

\item{clusLabels}{Cluster labels}

\item{colX}{Colours for the matrix}

\item{colY}{Colours for the response}

\item{myLegend}{Vector of strings with the names of the variables}

\item{fileName}{If \code{savePNG} is TRUE, this is the string containing the
name of the output file. Can be used to specify the folder path too. Default
is "posteriorSimilarityMatrix". The extension ".png" is automatically added
to this string.}

\item{savePNG}{Boolean: if TRUE, the plot is saved as a png file. Default is
FALSE.}

\item{semiSupervised}{Boolean flag: if TRUE, the response is plotted next to
the matrix.}

\item{showObsNames}{Boolean. If TRUE, observation names are shown in the
plot. Default is FALSE.}

\item{clr}{Boolean. If TRUE, rows are ordered by hierarchical clustering.
Default is FALSE.}

\item{clc}{Boolean. If TRUE, columns are ordered by hierarchical clustering.
Default is FALSE.}

\item{plotWidth}{Plot width. Default is 500.}

\item{plotHeight}{Plot height. Default is 450.}
}
\value{
No return value. This function plots the similarity matrix either
to screen or to a png file.
}
\description{
Plot similarity matrix with pheatmap
}
\examples{
# Load one dataset with 100 observations, 2 variables, 4 clusters
data <- as.matrix(read.csv(system.file("extdata", "dataset1.csv",
package = "klic"), row.names = 1))
# Load cluster labels
cluster_labels <- as.matrix(read.csv(system.file("extdata",
"cluster_labels.csv", package = "klic"), row.names = 1))

# Compute consensus clustering with K=4 clusters
cm <- coca::consensusCluster(data, 4)

# Plot consensus (similarity) matrix
plotSimilarityMatrix(cm)

# Plot consensus (similarity) matrix with response
names(cluster_labels) <- as.character(1:100)
rownames(cm) <- names(cluster_labels)
plotSimilarityMatrix(cm, y = cluster_labels)
}
\author{
Alessandra Cabassi \email{alessandra.cabassi@mrc-bsu.cam.ac.uk}
}
