% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastkmed.R
\name{fastkmed}
\alias{fastkmed}
\title{Simple and fast k-medoid algorithm from Park and Jun.}
\usage{
fastkmed(distdata, ncluster, iterate = 10, init = NULL)
}
\arguments{
\item{distdata}{A matrix of distance objects (n x n) or a diss class.}

\item{ncluster}{A number of cluster.}

\item{iterate}{A number of iteration for clustering algorithm.}

\item{init}{An index of the initial medoids.}
}
\value{
Function returns a partitioning clustering algorithm result consists of cluster
membership, cluster medoid, the minimum distance to the cluster medoid.
}
\description{
This function computes and returns the clustering result
computed by using a specified distance via Park and Jun's algorithm.
}
\details{
This is a k-medoids algorithm that has been proposed by Park and Jun. The algorihm
has been claimed to be fast and simple. The medoids updating in this algorihm is similar to
kmeans centroid updating.
}
\examples{
num <- as.matrix(iris[,1:4])
mrwdist <- distNumeric(num, num, method = "mrw")
result <- fastkmed(mrwdist, ncluster = 3, iterate = 50)
table(result$cluster, iris[,5])


}
\references{
Park, H., Jun, C., 2009. A simple and fast algorithm for k-medoids clustering.
Expert Systems with Applications 36, 3336-3341.
}
\author{
Weksi Budiaji \cr Contact: \email{budiaji@untirta.ac.id}
}
