% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooccur.R
\name{cooccur}
\alias{cooccur}
\title{Co-occurrence distance for binary/ categorical variables data.}
\usage{
cooccur(data)
}
\arguments{
\item{data}{A matrix or data frame of binary/ categorical variables. The values of matrix
should be integer, i.e 1, 2, 3, ...., or will be converted to integer otherwise.}
}
\value{
A matrix of distance from binary/ categorical variable.
}
\description{
This function computes and returns the distance matrix computed by
co-occurence distance.
}
\details{
This is a function to compute a co-occurence distance.
It returns a matrix of distance objects , i.e n x n.
}
\examples{
set.seed(1)
a <- matrix(sample(1:2, 7*3, replace = TRUE), 7, 3)
cooccur(a)


}
\references{
Harikumar, S., PV, S., 2015. K-medoid clustering for heterogeneous data sets.
JProcedia Computer Science 70, 226-237.
}
\author{
Weksi Budiaji \cr Contact: \email{budiaji@untirta.ac.id}
}
