% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow.R
\name{shadow}
\alias{shadow}
\title{Centroid shadow value (CSV) index of each cluster based on medoid.}
\usage{
shadow(distdata, idmedoid, idcluster)
}
\arguments{
\item{distdata}{A distance object/ a n x n distance matrix.}

\item{idmedoid}{A vector of id medoids.}

\item{idcluster}{A vector of cluster membership.}
}
\value{
Function returns a shadow value index and plot.
}
\description{
This function create a centroid shadow value index using medoid
(instead of centroid) and its plot.
}
\details{
This is a function to produce a centroid shadow value index
(using medoid) and its plot
for each cluster. The id medoids must match with the cluster
membership, for example, if the id medoids are 2, 25, and 57 (3 medoids),
the idcluster must have 3 unique memberships.
}
\examples{
distiris <- as.matrix(dist(iris[,1:4]))
res <- fastkmed(distiris, 3)
sha <- shadow(distiris, res$medoid, res$cluster)
sha$result[c(1:3,70:75,101:103),]
sha$plot

}
\references{
F. Leisch. 2010 Neighborhood graphs, stripes and shadow plots
for cluster visualization. Statistics and Computing. vol. 20, pp. 457-469
}
\author{
Weksi Budiaji \cr Contact: \email{budiaji@untirta.ac.id}
}
