% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_stability_selection.R
\name{stat.stability_selection}
\alias{stat.stability_selection}
\title{Importance statistics based on stability selection}
\usage{
stat.stability_selection(X, X_k, y, fitfun = stabs::glmnet.lasso, ...)
}
\arguments{
\item{X}{n-by-p matrix of original variables.}

\item{X_k}{n-by-p matrix of knockoff variables.}

\item{y}{response vector (length n)}

\item{fitfun}{fitfun a function that takes the arguments x, y as above, 
and additionally the number of variables to include in each model q. 
The function then needs to fit the model and to return a logical vector 
that indicates which variable was selected (among the q selected variables).
The name of the function should be prefixed by 'stabs::'.}

\item{...}{additional arguments specific to 'stabs' (see Details).}
}
\value{
A vector of statistics \eqn{W} of length p.
}
\description{
Computes the difference statistic
  \deqn{W_j = |Z_j| - |\tilde{Z}_j|}
where \eqn{Z_j} and \eqn{\tilde{Z}_j} are measure the importance
of the jth variable and its knockoff, respectively, based on the 
stability of their selection upon subsampling of the data.
}
\details{
This function uses the \code{stabs} package to compute
variable selection stability. The selection stability of the j-th 
variable is defined as its probability of being selected upon random
subsampling of the data. The default method for selecting variables 
in each subsampled dataset is \code{\link[stabs]{glmnet.lasso_maxCoef}}.

For a complete list of the available additional arguments, see \code{\link[stabs]{stabsel}}.
}
\examples{
p=100; n=100; k=15
mu = rep(0,p); Sigma = diag(p)
X = matrix(rnorm(n*p),n)
nonzero = sample(p, k)
beta = 3.5 * (1:p \%in\% nonzero)
y = X \%*\% beta + rnorm(n)
knockoffs = function(X) create.gaussian(X, mu, Sigma)

# Basic usage with default arguments
result = knockoff.filter(X, y, knockoffs=knockoffs,
                           statistic=stat.stability_selection)
print(result$selected)

# Advanced usage with custom arguments
foo = stat.stability_selection
k_stat = function(X, X_k, y) foo(X, X_k, y, fitfun=stabs::lars.lasso)
result = knockoff.filter(X, y, knockoffs=knockoffs, statistic=k_stat)
print(result$selected)

}
\seealso{
Other statistics: \code{\link{stat.forward_selection}},
  \code{\link{stat.glmnet_coefdiff}},
  \code{\link{stat.glmnet_lambdadiff}},
  \code{\link{stat.lasso_coefdiff_bin}},
  \code{\link{stat.lasso_coefdiff}},
  \code{\link{stat.lasso_lambdadiff_bin}},
  \code{\link{stat.lasso_lambdadiff}},
  \code{\link{stat.random_forest}},
  \code{\link{stat.sqrt_lasso}}
}
