\docType{methods}
\name{taggedText}
\alias{describe}
\alias{describe,-methods}
\alias{describe,kRp.hyphen-method}
\alias{describe,kRp.taggedText-method}
\alias{describe<-}
\alias{describe<-,-methods}
\alias{describe<-,kRp.hyphen-method}
\alias{describe<-,kRp.taggedText-method}
\alias{hyphenText}
\alias{hyphenText,-methods}
\alias{hyphenText,kRp.hyphen-method}
\alias{hyphenText<-}
\alias{hyphenText<-,-methods}
\alias{hyphenText<-,kRp.hyphen-method}
\alias{is.taggedText}
\alias{language}
\alias{language,-methods}
\alias{language,kRp.hyphen-method}
\alias{language,kRp.taggedText-method}
\alias{language<-}
\alias{language<-,-methods}
\alias{language<-,kRp.hyphen-method}
\alias{language<-,kRp.taggedText-method}
\alias{taggedText}
\alias{taggedText,-methods}
\alias{taggedText,kRp.taggedText-method}
\alias{taggedText<-}
\alias{taggedText<-,-methods}
\alias{taggedText<-,kRp.taggedText-method}
\title{Getter/setter methods for koRpus objects}
\usage{
taggedText(obj)

\S4method{taggedText}{kRp.taggedText}(obj)

taggedText(obj) <- value

\S4method{taggedText}{kRp.taggedText}(obj) <- value

describe(obj)

\S4method{describe}{kRp.taggedText}(obj)

describe(obj) <- value

\S4method{describe}{kRp.taggedText}(obj) <- value

\S4method{describe}{kRp.hyphen}(obj)

\S4method{describe}{kRp.hyphen}(obj) <- value

language(obj)

\S4method{language}{kRp.taggedText}(obj)

language(obj) <- value

\S4method{language}{kRp.taggedText}(obj) <- value

\S4method{language}{kRp.hyphen}(obj)

\S4method{language}{kRp.hyphen}(obj) <- value

is.taggedText(obj)

hyphenText(obj)

\S4method{hyphenText}{kRp.hyphen}(obj)

hyphenText(obj) <- value

\S4method{hyphenText}{kRp.hyphen}(obj) <- value
}
\arguments{
  \item{value}{The new value to replace the current with.}

  \item{obj}{An arbitrary \code{R} object.}
}
\description{
These methods should be used to get or set values of tagged
text objects generated by koRpus functions like
\code{treetag()} or \code{tokenize()}.
}
\details{
\itemize{ \item{\code{taggedText()} }{returns the
\code{TT.res} slot.} \item{\code{describe()} }{returns the
\code{desc} slot.} \item{\code{language()} }{returns the
\code{lang} slot.} \item{\code{hyphenText()} }{returns the
\code{hyphen} slot from objects of class
\code{kRp.hyphen}.} }
}
\examples{
\dontrun{
taggedText(tagged.txt)
}
}

