% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_hyphen.R
\docType{methods}
\name{hyphen,kRp.taggedText-method}
\alias{hyphen,kRp.taggedText-method}
\alias{hyphen}
\alias{hyphen_df,kRp.taggedText-method}
\alias{hyphen_c,kRp.taggedText-method}
\title{Automatic hyphenation}
\usage{
\S4method{hyphen}{kRp.taggedText}(words, hyph.pattern = NULL,
  min.length = 4, rm.hyph = TRUE, corp.rm.class = "nonpunct",
  corp.rm.tag = c(), quiet = FALSE, cache = TRUE,
  as = "kRp.hyphen")

\S4method{hyphen_df}{kRp.taggedText}(words, hyph.pattern = NULL,
  min.length = 4, rm.hyph = TRUE, quiet = FALSE, cache = TRUE)

\S4method{hyphen_c}{kRp.taggedText}(words, hyph.pattern = NULL,
  min.length = 4, rm.hyph = TRUE, quiet = FALSE, cache = TRUE)
}
\arguments{
\item{words}{Either an object of class \code{\link[koRpus:kRp.tagged-class]{kRp.tagged}},
      \code{\link[koRpus:kRp.txt.freq-class]{kRp.txt.freq}} or
\code{\link[koRpus:kRp.analysis-class]{kRp.analysis}},
      or a character vector with words to be hyphenated.}

\item{hyph.pattern}{Either an object of class \code{\link[sylly:kRp.hyph.pat-class]{kRp.hyph.pat}},
      or
a valid character string naming the language of the patterns to be used. See details.}

\item{min.length}{Integer,
      number of letters a word must have for considering a hyphenation. \code{hyphen} will
not split words after the first or before the last letter,
      so values smaller than 4 are not useful.}

\item{rm.hyph}{Logical,
      whether appearing hyphens in words should be removed before pattern matching.}

\item{corp.rm.class}{A character vector with word classes which should be ignored. The default value
\code{"nonpunct"} has special meaning and will cause the result of
\code{kRp.POS.tags(lang, c("punct","sentc"),
      list.classes=TRUE)} to be used. Relevant only if \code{words}
is a valid koRpus object.}

\item{corp.rm.tag}{A character vector with POS tags which should be ignored. Relevant only if \code{words}
is a valid koRpus object.}

\item{quiet}{Logical. If \code{FALSE}, short status messages will be shown.}

\item{cache}{Logical. \code{hyphen()} can cache results to speed up the process. If this option is set to \code{TRUE},
      the
current cache will be queried and new tokens also be added. Caches are language-specific and reside in an environment,
i.e., they are cleaned at the end of a session. If you want to save these for later use,
      see the option \code{hyph.cache.file}
in \code{\link[koRpus:set.kRp.env]{set.kRp.env}}.}

\item{as}{A character string defining the class of the object to be returned. Defaults to \code{"kRp.hyphen"},
      but can also be
set to \code{"data.frame"} or \code{"numeric"},
      returning only the central \code{data.frame} or the numeric vector of counted syllables,
respectively. For the latter two options,
      you can alternatively use the shortcut methods \code{hyphen_df} or  \code{hyphen_c}.}
}
\value{
An object of class \code{\link[sylly:kRp.hyphen-class]{kRp.hyphen}},
      \code{data.frame} or a numeric vector, depending on the value
   of the \code{as} argument.
}
\description{
These methods implement word hyphenation, based on Liang's algorithm.
For details, please refer to the documentation for the generic
\code{\link[sylly:hyphen]{hyphen}} method in the \code{sylly} package.
}
\examples{
\dontrun{
hyphen(tagged.text)
}
}
\references{
Liang, F.M. (1983). \emph{Word Hy-phen-a-tion by Com-put-er}.
     Dissertation, Stanford University, Dept. of Computer Science.

[1] \url{http://tug.ctan.org/tex-archive/language/hyph-utf8/tex/generic/hyph-utf8/patterns/}

[2] \url{http://www.ctan.org/tex-archive/macros/latex/base/lppl.txt}
}
\seealso{
\code{\link[sylly:read.hyph.pat]{read.hyph.pat}},
   \code{\link[sylly:manage.hyph.pat]{manage.hyph.pat}}
}
\keyword{hyphenation}
