% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VisualizationFunctions.R
\name{plot_filter_results}
\alias{plot_filter_results}
\title{Plot descriptives from one or more fixation detection algorithms}
\usage{
plot_filter_results(data_in, plot.variable = "rmsd")
}
\arguments{
\item{data_in}{Data frame with fixations to plot}

\item{plot.variable}{Variable to plot. If left empty, RMSD of subsent samples (precision) are plotted. Alternatives are "rmsd", "rms.from.center", "duration", "missing.samples"}
}
\value{
A ggplot with visualizations of the selected validity measure
}
\description{
This function visualizes validity measures of fixations detected with one or more fixation detection algorithms.
The function is tested for fixation data frames generated with kollaR event detection algorithms. By default, the function can plot
Root Mean Square Deviations of detected fixations, fixation duration and the proportion of missing raw samples.
The output data is a ggplot which can be modified further outside the function.
If you want to use this function to compare more than one fixation detection algorithms, combine them using the function
rbind in base R. For example, \code{rbind(my_data1[["fixations"]], my_data2[["fixations"]])} would generate a combined data frame with the
fixations detected by two event classification procedures.
This function will be replaced by 'plot_algorithm_results' in future versions.
}
\examples{
plot_filter_results(data_in = sample.data.fixations, plot.variable = "rmsd")
}
