% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tkonfound.R
\name{tkonfound}
\alias{tkonfound}
\title{Perform Sensitivity Analysis on 2x2 Tables}
\usage{
tkonfound(
  a,
  b,
  c,
  d,
  alpha = 0.05,
  switch_trm = TRUE,
  test = "fisher",
  replace = "control",
  to_return = to_return
)
}
\arguments{
\item{a}{Number of unsuccessful cases in the control group.}

\item{b}{Number of successful cases in the control group.}

\item{c}{Number of unsuccessful cases in the treatment group.}

\item{d}{Number of successful cases in the treatment group.}

\item{alpha}{Significance level for the statistical test, default is 0.05.}

\item{switch_trm}{Boolean indicating whether to switch treatment row cells,
default is TRUE.}

\item{test}{Type of statistical test to use, either "fisher"
(default) or "chisq".}

\item{replace}{Indicates whether to use the entire sample or the control
group for base rate calculation, default is "control".}

\item{to_return}{Type of output to return, either "raw_output" or "print".}
}
\value{
Returns detailed information about the sensitivity analysis,
        including the number of cases to be replaced (RIR), user-entered
        table, transfer table, and conclusions.
}
\description{
This function performs a sensitivity analysis on a 2x2 contingency table.
It calculates the number of cases that need to be replaced to invalidate
or sustain the statistical inference. The function also allows switching
between treatment success and failure or control success and failure
based on the provided parameters.
}
