% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpiwidget.R
\name{kpiwidget}
\alias{kpiwidget}
\title{Create an interactive KPI widget for Quarto dashboards with Crosstalk support.}
\usage{
kpiwidget(
  data,
  kpi = c("count", "distinctCount", "duplicates", "sum", "mean", "min", "max"),
  comparison = NULL,
  column = NULL,
  selection = NULL,
  group1 = NULL,
  group2 = NULL,
  decimals = 1,
  big_mark = " ",
  prefix = NULL,
  suffix = NULL,
  width = NULL,
  height = NULL,
  elementId = NULL,
  group = NULL
)
}
\arguments{
\item{data}{A \code{crosstalk::SharedData} object.}

\item{kpi}{A character string specifying the metric to compute.
Options are: \code{"sum"}, \code{"mean"}, \code{"min"}, \code{"max"},
\code{"count"}, \code{"distinctCount"}, \code{"duplicates"}. The default is count.}

\item{comparison}{Optional. A character string indicating a comparison mode.
Options are \code{"ratio"} or \code{"share"}. If not provided (NULL), no comparison is performed.}

\item{column}{A column name (as a string) to be used for numeric aggregation.
In standard mode this is required. In comparison mode, if provided it is used for both groups;
if omitted, counts are used.}

\item{selection}{A one-sided formula to filter rows.}

\item{group1}{For comparison mode: a one-sided formula defining group 1.
This is required in comparison mode.}

\item{group2}{For comparison mode: a one-sided formula defining group 2.
For \code{comparison = "ratio"}, if not provided, it defaults to the complement of group1.
For \code{comparison = "share"}, if not provided, it defaults to all rows.}

\item{decimals}{Number of decimals to round the computed result. Default: 1.}

\item{big_mark}{Character to be used as the thousands separator. Default: " ".}

\item{prefix}{A string to be prepended to the displayed value.}

\item{suffix}{A string to be appended to the displayed value.}

\item{width}{Widget width (passed to \code{htmlwidgets::createWidget}).}

\item{height}{Widget height.}

\item{elementId}{Optional element ID for the widget.}

\item{group}{crosstalk group name. Typically provided by the SharedData object.}
}
\value{
An object of class \code{htmlwidget} that will print itself into an HTML page.
}
\description{
This function computes and displays a key performance indicator (KPI) based on a
variety of statistics. The data can be filtered using formulas.
In addition, a comparison mode can be applied by specifying the \code{comparison}
parameter as either \code{"ratio"} or \code{"share"}. For example, if
\code{comparison = "ratio"} and \code{kpi = "sum"} (with a column indicating sales),
the widget will calculate the ratio of sales between two groups defined by \code{group1}
and \code{group2}.
}
\examples{
# Standard KPI example:
mtcars_shared <- crosstalk::SharedData$new(mtcars, key = ~ 1:nrow(mtcars), group = "mtcars_group")
kpiwidget(mtcars_shared, kpi = "mean", column = "mpg", decimals = 1,
suffix = " mpg", height = "25px"
)

# Comparison (ratio) example: ratio of mean mpg between two groups.
kpiwidget(mtcars_shared, kpi = "mean", comparison = "ratio", column = "mpg",
  group1 = ~ cyl == 4, group2 = ~ cyl == 6,  height = "25px"
)

}
