% Generated by roxygen2 (4.0.2): do not edit by hand
\name{kpod}
\alias{kpod}
\title{Function for performing k-POD}
\usage{
kpod(X, k, kmpp_flag = TRUE, maxiter = 100)
}
\arguments{
\item{X}{Data matrix containing missing entries whose rows are observations and columns are features}

\item{k}{Number of clusters}

\item{kmpp_flag}{(Optional) Indicator for whether or not to initialize with k-means++}

\item{maxiter}{(Optional) Maximum number of iterations}
}
\value{
cluster: Clustering assignment obtained with k-POD

cluster_list: List containing clustering assignments obtained in each iteration

obj_vals: List containing the k-means objective function in each iteration

fit: Fit of clustering assignment obtained with k-POD (calculated as 1-(total withinss/totss))

fit_list: List containing fit of clustering assignment obtained in each iteration
}
\description{
\code{kpod} Function for performing k-POD, a method for k-means clustering on partially observed data
}
\examples{
p <- 5
n <- 200
k <- 3
sigma <- 0.15
missing <- 0.20
Data <- makeData(p,n,k,sigma,missing)
X <- Data$Missing
Orig <- Data$Orig
truth <- Data$truth

kpod_result <- kpod(X,k)
kpodclusters <- kpod_result$cluster
}
\author{
Jocelyn T. Chi
}

