% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmassessmultiplicative.R
\name{kmassessmultiplicative}
\alias{kmassessmultiplicative}
\title{Update probability distribution applying multiplicative rule}
\usage{
kmassessmultiplicative(probs, ks, zeta0, zeta1, question, response)
}
\arguments{
\item{probs}{Probability distribution over the knowledge structure (vector)}

\item{ks}{Binary matrix of the knowledge structure}

\item{zeta0}{Vector of update parameters for wrong responses}

\item{zeta1}{Vector of update parameters for correct responses}

\item{question}{Item that has been posed}

\item{response}{Correctness of received response (0 or 1)}
}
\value{
Updated probability vector
}
\description{
\code{kmassessmultiplicative} updates a probability distribution on a
knowledge structure according to the multiplicative rule.
}
\examples{
kmassessmultiplicative(c(0.02, 0.1, 0.07, 0.01, 0.4, 0.17, 0.07, 0.08, 0.08),
                 xpl$space,
                 rep(1.2,4),
                 rep(2.1,4),
                 3,
                 1
                )

}
\seealso{
Other Knowledge assessment: 
\code{\link{kmassess}()},
\code{\link{kmassessbayesian}()},
\code{\link{kmassesshalfsplit}()},
\code{\link{kmassessinformative}()},
\code{\link{kmassessmentsimulation}()},
\code{\link{kmsassess}()}
}
\concept{Knowledge assessment}
