% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBINDEN.R
\name{ROBINDEN}
\alias{ROBINDEN}
\title{ROBINDEN (ROBust INitialization based on inverse DENsity estimator)}
\usage{
ROBINDEN(D, data, k, mp = 10)
}
\arguments{
\item{D}{A distance matrix calculated on \code{data}.}

\item{data}{A data matrix with n observations and p variables.}

\item{k}{The number of cluster centers to find.}

\item{mp}{The number of the nearest neighbors to find dense regions by LOF, the default is 10.}
}
\value{
\item{centers}{A numeric vector of \code{k} initial cluster centers corresponding to the k indices of observations.}
\item{idpoints}{A real vector containing the inverse density values of each point (observation).}
}
\description{
\code{ROBINDEN} searches for k initial cluster seeds for k-means-based clustering methods.
}
\details{
The centers are the observations located in the most dense region
and far away from each other at the same time.
In order to find the observations in the highly dense region,
ROBINPOINTDEN uses point density estimation
(instead of Local Outlier Factor, Breunig et al (2000)), see more details.
}
\note{
this is a slightly modified version of ROBIN algorithm implementation done by
Sarka Brodinova <sarka.brodinova@tuwien.ac.at>.
}
\examples{
K=5;
nk=100
Z <- rnorm(2 * K * nk);
centers_aux <- -floor(K/2):floor(K/2)
mues <- rep(5*centers_aux,2*nk*K )
X <-  matrix(Z + mues, ncol=2)
# Generate sintetic outliers (contamination level 20\%)
X[sample(1:(nk * K),(nk * K) * 0.2), ] <-matrix(runif((nk * K) * 0.2 * 2,
                                          3 * min(X), 3 * max(X)),
                                          ncol = 2, nrow = (nk * K) * 0.2)
res <- ROBINDEN(D =dist(X), data=X, k = K);
# plot the Initial centers found
plot(X)
points(X[res$centers,],pch=19,col=4,cex=2)
}
\references{
Hasan AM, et al. Robust partitional clustering by
outlier and density insensitive seeding. Pattern Recognition Letters, 30(11), 994-1002, 2009.
}
\seealso{
\code{\link[dbscan]{lof}}
}
\author{
Juan Domingo Gonzalez <juanrst@hotmail.com>
}
