% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likert.R
\name{likert}
\alias{likert}
\title{Percentage tables for Likert Scale variables}
\usage{
likert(vlist, data, labels, outdir, fn, rows = TRUE)
}
\arguments{
\item{vlist}{A vector of variable names}

\item{data}{A data frame}

\item{labels}{A vector of values to replace existing levels}

\item{outdir}{Output directory}

\item{fn}{file name for output: not used yet. See example for one way to save result.}

\item{rows}{Currently unused indicator for whether output should
be transposed.}
}
\value{
character vector
}
\description{
Creates a table with columns for allowed values and rows for
variables.
}
\examples{
vvector <- c("Strongly Disagree", "Disagree", "Neutral",
              "Agree", "Strongly Agree")
set.seed(2342234)
N <- 142
scales <-
    data.frame(Vegas = factor(sample(1:5, N, replace = TRUE), labels = vvector),
               NewYork = factor(sample(1:5, N, replace = TRUE), labels = vvector),
               Paris = factor(sample(1:5, N, replace = TRUE), labels = vvector),
               Berlin = factor(sample(1:5, N, replace = TRUE), labels = vvector))

(mySummary1 <- likert(c("Vegas", "NewYork", "Paris"), scales))

(mySummary2 <- likert(c("Vegas", "NewYork", "Paris"), scales,
                    labels = c("SD", "D", "N", "A", "SA")))

 ## Example of how one might write this in a file. The fn argument is not currently
 ## enabled, but the following will work.
 ## print(xtable::xtable(mySummary1, digits = 0), type = "html", file = "varCount-1.html")       
  
}
\author{
Paul Johnson <pauljohn@ku.edu>
}
