\name{random.functions}
\alias{dbern}
\alias{rbigamma}
\alias{rbilogistic}
\alias{dcorbern}
\alias{dmixnorm}
\alias{dnorm.norm.gamma}
\alias{rbern}
\alias{rejective.sampling}
\alias{rnorm.ar}
\alias{rmixnorm}
\alias{rnorm.norm.gamma}
\alias{rdoublexp}
\alias{ddoublexp}
\alias{qdoublexp}
\alias{pdoublexp}
\alias{rbidoublexp}

\title{
Random Functions
}
\description{
Generate samples from random variables.
}
\usage{

dbern(x, prob, log = FALSE)

dcorbern(x, p, a, log = FALSE)

dmixnorm(x, mix.p, sd1, sd2, log = FALSE)

dnorm.norm.gamma(x, p, same.distr = FALSE, log = FALSE)

rbern(n, prob, generalized = FALSE)

rbigamma(n, shape.1, shape.2, rate.1, rate.2, rho)

rbilogistic(n, loc.1, loc.2, scale.1, scale.2, rho) 

rejective.sampling(N, n, pik)

rnorm.ar(n, sd, rho)

rnorm.norm.gamma(n, mu.0, lambda, alpha, beta)

rmixnorm (n, mix.p, mu1, mu2, sd1, sd2)

rdoublexp(n, location=0, scale=1) 
ddoublexp(x, location=0, scale=1) 
qdoublexp(p, location=0, scale=1) 
pdoublexp(q, location=0, scale=1) 

rbidoublexp(n, loc.1, loc.2, scale.1, scale.2, rho) 

}
%- maybe also 'usage' for other objects documented here.
\arguments{

  \item{q}{
%%     ~~Describe \code{x} here~~
}
  \item{location}{
%%     ~~Describe \code{x} here~~
}
  \item{scale}{
%%     ~~Describe \code{x} here~~
}


  \item{x}{
%%     ~~Describe \code{x} here~~
}
  \item{prob}{
%%     ~~Describe \code{prob} here~~
}
  \item{log}{
%%     ~~Describe \code{log} here~~
}

  \item{p}{
%%     ~~Describe \code{p} here~~
}
  \item{a}{
%%     ~~Describe \code{a} here~~
}

  \item{mix.p}{
%%     ~~Describe \code{mix.p} here~~
}
  \item{sd1}{
%%     ~~Describe \code{sd1} here~~
}
  \item{sd2}{
%%     ~~Describe \code{sd2} here~~
}

  \item{same.distr}{
%%     ~~Describe \code{same.distr} here~~
}

  \item{n}{
%%     ~~Describe \code{n} here~~
}
  \item{generalized}{
%%     ~~Describe \code{generalized} here~~
}

  \item{N}{
%%     ~~Describe \code{N} here~~
}
  \item{pik}{
%%     ~~Describe \code{pik} here~~
}

  \item{mu}{
%%     ~~Describe \code{mu} here~~
}
  \item{mu1}{
%%     ~~Describe \code{mu} here~~
}
  \item{mu2}{
%%     ~~Describe \code{mu} here~~
}
  \item{sd}{
%%     ~~Describe \code{sd} here~~
}
  \item{alpha}{
%%     ~~Describe \code{alpha} here~~
}

  \item{mu.0}{
%%     ~~Describe \code{mu.0} here~~
}
  \item{lambda}{
%%     ~~Describe \code{lambda} here~~
}
  \item{beta}{
%%     ~~Describe \code{beta} here~~
}
  \item{loc.1}{
%%     ~~Describe \code{beta} here~~
}
  \item{loc.2}{
%%     ~~Describe \code{beta} here~~
}
  \item{scale.1}{
%%     ~~Describe \code{beta} here~~
}
  \item{scale.2}{
%%     ~~Describe \code{beta} here~~
}
  \item{rate.1}{
%%     ~~Describe \code{beta} here~~
}
  \item{rate.2}{
%%     ~~Describe \code{beta} here~~
}
  \item{shape.1}{
%%     ~~Describe \code{beta} here~~
}
  \item{shape.2}{
%%     ~~Describe \code{beta} here~~
}
  \item{rho}{
%%     ~~Describe \code{beta} here~~
}
}
\details{
rbern generates Bernoulli random variables.\cr
rbilogistic generates a bivariate logistic distribution for correlation coefficient 0.5, or [-0.271, 0.478]. \cr
In the former case it is generated by calling \code{rbilogis}, part of the VGAM package; in the latter case it is generated via the AMH copular.\cr
rnorm.ar simulate autoregressive normal random variables, correlation is rho^d between x_1 and x_(1+d)
}

\examples{

set.seed(1)
rbern(n=10, p=1/2)
rbern(n=2, p=c(.999,.001))

\dontrun{
tmp=replicate(1e4, rnorm.cor(10, 1, .81))
round(cor(t(tmp)),2)
}
}
