% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid.R
\name{kzpdr.tol}
\alias{kzpdr.tol}
\title{Search Appropriate Tolerances Setting for Wave Parameter Estimation}
\usage{
kzpdr.tol(rec = ls(1), t.D = seq(1, 10, 1), t.F = 0.01)
}
\arguments{
\item{rec}{Data list from the outputs of function \code{kzpdr}. It includes the
data frame for the marked frequency values and corresponding directions.
Defaults is searching for available records in the environment.}

\item{t.D}{Vector for search range of direction tolerance.
Default is 1:10 (in degree).}

\item{t.F}{Vector for search range of frequency tolerance. 
Default value is c(0.01).}
}
\description{
\code{kzpdr.tol} will help to find the feasible tolerance settings for 
the wave parameter estimation.
}
\details{
Since the expected wave number is known(see \code{kzpdr.spikes}), we can  
search for the tolerance settings that would generate estimations with wave
number in this range. A table will be presented to summary feasible settings.

    The searching process would stop when it finsihed the search range, or the 
increasing of the tolerance led to null result.
}
\examples{

# load pre-saved data 
data(kzpdr.demo); 

# search for tolerance 
kzpdr.tol(kzpdr.demo, t.D = c(1,2,3), t.F = 0.005)

}
\seealso{
\code{\link{kzpdr}}, \code{\link{kzpdr.eval}}
 			\code{\link{kzpdr.valid}}, \code{\link{kzpdr.spikes}}
}

