% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelled.R
\name{labelled}
\alias{labelled}
\alias{is.labelled}
\title{Create a labelled vector.}
\usage{
labelled(x, labels, label = NULL)

is.labelled(x)
}
\arguments{
\item{x}{A vector to label. Must be either numeric (integer or double) or
character.}

\item{labels}{A named vector. The vector should be the same type as
\code{x}. Unlike factors, labels don't need to be exhaustive: only a fraction
of the values might be labelled.}

\item{label}{A short, human-readable description of the vector.}
}
\value{
An object of class "haven_labelled" or "haven_labelled_spss".
}
\description{
A labelled vector is a common data structure in other statistical environments,
allowing you to assign text labels to specific values.
}
\examples{
s1 <- labelled(c("M", "M", "F"), c(Male = "M", Female = "F"))
s1
str(s1)
s2 <- labelled(c(1, 1, 2), c(Male = 1, Female = 2),
               label="Assigned sex at birth")
s2
str(s2)

# Unfortunately it's not possible to make as.factor() work for labelled objects
# so instead use to_factor(). This works for all types of labelled vectors.
to_factor(s1)
to_factor(s1, levels = "prefixed")
to_factor(s2)

# Other statistical software supports multiple types of missing values
s3 <- labelled_spss(c(1, 1, 2, 2, 8, 9),
               c(Male = 1, Female = 2, Refused = 8, "Not applicable" = 9),
               na_values = c(8, 9)

)
s3
str(s3)
to_factor(s3)
to_factor(s3, user_na_to_na = TRUE)
is.labelled(s1)
}
\seealso{
\code{\link[haven]{labelled}} (\pkg{haven})

\code{\link[haven]{is.labelled}} (\pkg{haven})
}
