% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_labs_att.R
\name{check_labs_att}
\alias{check_labs_att}
\title{Check Data Frame for Specified labelr Attribute}
\usage{
check_labs_att(data, att = NULL)
}
\arguments{
\item{data}{the data.frame you are checking for the presence (or absence)
of labelr meta-data.}

\item{att}{the specific label meta-data you are looking for. Default of NULL
will return TRUE if any valid labelr meta-data item of types "frame.lab",
"name.labs", "val.labs", or "factor." (period is part of the substring) is
present.}
}
\value{
TRUE if any instance of the default or user-specified meta-data
attribute is found, FALSE if not.
}
\description{
\code{check_labs_att} returns TRUE if your data.frame has the specific attribute
indicated and FALSE if it does not.
}
\examples{
# make toy demographic (gender, raceth, etc.) data set
set.seed(555)
df <- make_demo_data(n = 1000) # another labelr:: function
# let's add variable VALUE labels for variable "race"
df <- add_val_labs(df,
  vars = "raceth", vals = c(1:7),
  labs = c("White", "Black", "Hispanic", "Asian", "AIAN", "Multi", "Other"),
  max.unique.vals = 50
)

check_labs_att(df) # is any valid labelr lab(el) attribute present?
check_labs_att(df, "val.labs.race") # "race" lab specifically TRUE
}
