% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{mapblock}
\alias{mapblock}
\title{Apply a function over blocks of a vector}
\arguments{
\item{x}{Any indexable data structure}

\item{block}{The block size used to map over}

\item{fn}{A function applied to a block}

\item{\dots}{Optional arguments to pass to sapply}
}
\value{
A vector containing the result of fn applied to each block
}
\description{
This form of map operates on non-overlapping adjacent blocks of
a data structure.
}
\section{Usage}{

mapblock(x, window, fn, ...)
}

\section{Details}{

This function is useful primarily in the two-dimensional form. The
use case is when a number of rotation matrices should be applied
to a set of points. By collecting all the rotation matrices into
a larger matrix, it is easy to produce a map process along the
sub-matrices in a way that doesn't require managing indices.

Unlike maprange, mapblock doesn't have a do.pad option. Typical
usage scenarios begin by constructing a matrix block that is
compatible with some other data structure. Hence given a matrix
A with dimensions m x n and a window of length m, it is possible
to construct a k x m block matrix B composed of smaller m x m
sub-matrices such that each iteration of mapblock operates on a
1 x m vector against an m x m sub-matrix. The point is that by
construction the dimensions must be compatible, so padding
after the fact becomes unnecessary.

The 1D version is provided for completeness and is equivalent to a
2D map, except on the edge cases.
}
\examples{
# Apply multiple rotation matrices to a set of points
a <- matrix(sample(12, 20, replace=TRUE), nrow=2)
theta <- 2 * pi * sample(360,4, replace=TRUE) / 360
b <- fold(theta, function(d,acc)
  cbind(acc,matrix(c(cos(d),sin(d),-sin(d),cos(d)), nrow=2)), c())
z <- mapblock(b, 2, function(m) m \%*\% a, simplify=FALSE)

# The 1D version is equivalent to a 2D map
x <- 1:24
mapblock(x, 4, sum) == map(matrix(x,nrow=4), sum)

}
\author{
Brian Lee Yung Rowe
}

