% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_np.R
\name{lsm_c_np}
\alias{lsm_c_np}
\alias{lsm_c_np.RasterLayer}
\alias{lsm_c_np.RasterStack}
\alias{lsm_c_np.RasterBrick}
\alias{lsm_c_np.list}
\title{NP (class level)}
\usage{
lsm_c_np(landscape, directions)

\method{lsm_c_np}{RasterLayer}(landscape, directions = 8)

\method{lsm_c_np}{RasterStack}(landscape, directions = 8)

\method{lsm_c_np}{RasterBrick}(landscape, directions = 8)

\method{lsm_c_np}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Number of patches (Aggregation metric)
}
\details{
\deqn{NP = n_{i}}
where \eqn{n_{i}} is the number of patches.

NP is an 'Aggregation metric'. It describes the fragmentation of a class, however, does not
necessarily contain information about the configuration or composition of the class.

\subsection{Units}{None}
\subsection{Ranges}{NP >= 1}
\subsection{Behaviour}{Equals NP = 1 when only one patch is present and
increases, without limit, as the number of patches increases}
}
\examples{
lsm_c_np(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
\seealso{
\code{\link{lsm_l_np}}
}
