% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_boundaries.R
\name{get_boundaries}
\alias{get_boundaries}
\alias{get_boundaries.RasterLayer}
\alias{get_boundaries.RasterStack}
\alias{get_boundaries.RasterBrick}
\alias{get_boundaries.stars}
\alias{get_boundaries.list}
\alias{get_boundaries_calc}
\title{get_boundaries}
\usage{
get_boundaries(
  landscape,
  consider_boundary,
  edge_depth,
  as_NA,
  patch_id,
  return_raster
)

\method{get_boundaries}{RasterLayer}(
  landscape,
  consider_boundary = FALSE,
  edge_depth = 1,
  as_NA = FALSE,
  patch_id = FALSE,
  return_raster = TRUE
)

\method{get_boundaries}{RasterStack}(
  landscape,
  consider_boundary = FALSE,
  edge_depth = 1,
  as_NA = FALSE,
  patch_id = FALSE,
  return_raster = TRUE
)

\method{get_boundaries}{RasterBrick}(
  landscape,
  consider_boundary = FALSE,
  edge_depth = 1,
  as_NA = FALSE,
  patch_id = FALSE,
  return_raster = TRUE
)

\method{get_boundaries}{stars}(
  landscape,
  consider_boundary = FALSE,
  edge_depth = 1,
  as_NA = FALSE,
  patch_id = FALSE,
  return_raster = TRUE
)

\method{get_boundaries}{list}(
  landscape,
  consider_boundary = FALSE,
  edge_depth = 1,
  as_NA = FALSE,
  patch_id = FALSE,
  return_raster = TRUE
)

get_boundaries_calc(landscape, consider_boundary, edge_depth, as_NA, patch_id)
}
\arguments{
\item{landscape}{RasterLayer or matrix.}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as edge.}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell.}

\item{as_NA}{If true, non-boundary cells area labeld NA.}

\item{patch_id}{If true, boundary/edge cells are labeled with the original patch id.}

\item{return_raster}{If false, matrix is returned.}
}
\value{
List with RasterLayer or matrix
}
\description{
Get boundary cells of patches
}
\details{
All boundary/edge cells are labeled 1, all non-boundary cells 0. NA values are
not changed. Boundary cells are defined as cells that neighbour either a NA
cell or a cell with a different value than itself. Non-boundary cells only
neighbour cells with the same value than themself.
}
\examples{
class_1 <- get_patches(landscape, class = 1)[[1]]

get_boundaries(class_1)
get_boundaries(class_1, return_raster = FALSE)

}
