% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_lsi.R
\name{lsm_c_lsi}
\alias{lsm_c_lsi}
\title{LSI (class level)}
\usage{
lsm_c_lsi(landscape)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}
}
\value{
tibble
}
\description{
Landscape shape index (Aggregation metric)
}
\details{
\deqn{LSI = \frac{e_{i}} {\min e_{i}}}
where \eqn{e_{i}} is the total edge length in cell surfaces and \eqn{\min e_{i}}
is the minimum total edge length in cell surfaces.

LSI is an 'Aggregation metric'. It is the ratio between the actual edge length of
class i and the hypothetical minimum edge length of class i. The minimum edge length equals
the edge length if class i would be maximally aggregated.

\subsection{Units}{None}
\subsection{Ranges}{LSI >= 1}
\subsection{Behaviour}{Equals LSI = 1 when only one squared patch is present or all
patches are maximally aggregated. Increases, without limit, as the length of the
actual edges increases, i.e. the patches become less compact.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_c_lsi(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

Patton, D. R. 1975. A diversity index for quantifying habitat "edge".
Wildl. Soc.Bull. 3:171-173.
}
\seealso{
\code{\link{lsm_p_shape}}, \cr
\code{\link{lsm_l_lsi}}
}
