% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_siei.R
\name{lsm_l_siei}
\alias{lsm_l_siei}
\title{SIEI (landscape level)}
\usage{
lsm_l_siei(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Simpson's evenness index (Diversity metric)
}
\details{
\deqn{SIEI = \frac{1 - \sum \limits_{i = 1}^{m} P_{i}^{2}} {1 - \frac{1} {m}}}
where \eqn{P_{i}} is the proportion of class i and \eqn{m} is the
number of classes.

SIEI is a 'Diversity metric'. The metric is widely used in biodiversity and ecology.
It is the ratio between the actual Simpson's diversity  index and the theoretical maximum
Simpson's diversity index.

\subsection{Units}{None}
\subsection{Range}{0 < SIEI <= 1}
\subsection{Behaviour}{Equals SIEI = 0 when only one patch is present and approaches
SIEI = 1 when the number of class types increases while the proportions are
equally distributed}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_l_siei(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

Simpson, E. H. 1949. Measurement of diversity. Nature 163:688
}
\seealso{
\code{\link{lsm_c_pland}},
\code{\link{lsm_l_pr}}
}
