% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_facetplot.R
\name{util_facetplot}
\alias{util_facetplot}
\title{util_facetplot() for visual overview}
\usage{
util_facetplot(mpdta, nrow = NULL, ncol = NULL)
}
\arguments{
\item{mpdta}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{nrow, ncol}{Number of rows and columns.}
}
\value{
ggplot
}
\description{
Plot multiple raster (RasterStack, -brick or list of raster) side by side as facets.
}
\details{
The output uses ggplots faceting and beforehand raster2tibble.
Thus you will loose any spatial information (resolution, extent or reference system).
Only raw tiles are displayed and the number of cells determines the size of the plot.
This can lead to huge size differences between maps, but if you plot for example
multiple maps from a time series side by side it works as intended. Depending on the
size of the maps it is advisable to store the plot in an object and print it to
a file. This will help with compressing and rendering the image.
}
\examples{
\dontrun{
l1 <- NLMR::nlm_fbm(64, 64)
l2 <- NLMR::nlm_planargradient(64, 64)
l3 <- NLMR::nlm_randomrectangularcluster(ncol = 60, nrow = 60, minl = 5, maxl = 10)
l4 <- NLMR::nlm_random(64, 64)

bri1 <- raster::brick(l1, l2)
names(bri1) <- c("FBM", "GRADIENT")
util_facetplot(bri1)

lst1 <- list(layer1 = l1,
             layer2 = l2,
             layer3 = l3,
             layer4 = l4)
util_facetplot(lst1)
}

}
