% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgriLand.R
\name{AgriLand}
\alias{AgriLand}
\title{Landscape generation}
\usage{
AgriLand(landscape, filename = "landscapeTEST1", propSR, isolSR, propRR,
  isolRR, strat, Nhote, nYears, Cmax0, Cmax1, seed, graphOn)
}
\arguments{
\item{landscape}{a spatialpolygon object containing field coordinates.}

\item{filename}{a character string specifying the output layer name.}

\item{propSR}{proportion of fields where resistance is deployed: (RC)/(SC+RC) or (RC1+RC2)/(SC+RC1+RC2). Must be between 0 and 1.}

\item{isolSR}{an integer giving the spatial aggregation of fields where resistance is deployed (1=highly fragmented, 2=balanced, 3=highly aggregated).}

\item{propRR}{when applicable (mixtures and mosaics only), relative proportion of the second resistant cultivar: (RC2)/(RC1+RC2). Must be between 0 and 1.}

\item{isolRR}{when applicable, an integer giving the spatial (for mosaics) or temporal (for rotations) aggregation of fields 
cultivated with the second resistant cultivar (1=highly fragmented, 2=balanced, 3=highly aggregated).}

\item{strat}{a character string specifying the deployment strategy ("MO"=mosaic, "MI"=mixture, "RO"=rotations, "PY"=pyramiding).}

\item{Nhote}{an integer giving the number of cultivars (1, 2 or 3).}

\item{nYears}{an integer giving the number of simulated years.}

\item{Cmax0}{carrying capacity of the susceptible cultivar in number of hosts per meter square.}

\item{Cmax1}{carrying capacity of the resistant cultivars in number of hosts per meter square.}

\item{seed}{an integer giving the seed value (for random number generator).}

\item{graphOn}{a logical indicating if a graph of the landscape must be generated (1) or not (0).}
}
\value{
a shapefile containing the landscape structure (i.e. coordinates of field boundaries) and composition (i.e. cultivars).
}
\description{
Generate a landscape composed of fields where a susceptible (SC) and one (RC) or two (RC1 and RC2) resistant cultivars 
are allocated with controlled proportions and spatio-temporal aggregation.
}
\details{
An algorithm based on latent Gaussian fields is used to allocate two different crop cultivars across the simulated landscapes 
(e.g. a susceptible and a resistant cultivar, denoted as SC and RC, respectively). This algorithm allows the control of the proportions 
of each cultivar in terms of surface coverage, and their level of spatial aggregation. A random vector of values is drawn from a 
multivariate normal distribution with expectation 0 and a variance-covariance matrix which depends on the pairwise distances between 
the centroids of the fields. Next, the crop cultivars are allocated to different fields depending on whether each value drawn from the 
multivariate normal distribution is above or below a threshold. The proportion of each cultivar in the landscape is controlled by the value 
of this threshold. The sequential use of this algorithm allows the allocation of more than two crop cultivars (e.g. SC, RC1 and RC2). 
Therefore, deployment strategies involving two sources of resistance is simulated by: 
\enumerate{
\item running the allocation algorithm once to segregate the fields where the susceptible cultivar is grown, and 
\item applying one of the following deployment strategies to the remaining candidate fields:
\itemize{
\item Mosaics: two resistant cultivars (RC1 and RC2, carrying the first and the second resistance sources, respectively) are assigned to candidate 
fields by re-running the allocation algorithm;
\item Mixtures: both RC1 and RC2 are allocated to all candidate fields;
\item Rotations: RC1 and RC2 are alternatively cultivated in candidate fields, depending on the number of cropping 
seasons over which a given cultivar is grown before being rotated;
\item Pyramiding: all candidate fields are cultivated with RC12, a resistant cultivar carrying both resistance sources.
}
}
}
\examples{
## Generate a landscape consisting in a mosaic of fields cultivated with a susceptible cultivar
## and two resistant cultivars in balanced proportions and high level of spatial aggregation
\dontrun{ 
landscapeTEST1
AgriLand(landscapeTEST1,filename="landscapeTEST1",propSR=2/3,isolSR=3,
propRR=1/2,isolRR=3,strat="MO",Nhote=3,nYears=30,Cmax0=2,Cmax1=2,seed=12345,graphOn=1)
}
}
\references{
Rimbaud L., Papaïx J., Rey J.-F., Barrett L. G. and Thrall P. H. (in press). Assessing the durability and efficiency of landscape-based strategies to deploy plant resistance to pathogens. \emph{PLoS Computational Biology}.
}
