% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NEST.R
\name{NEST}
\alias{NEST}
\title{Estimate Number of Dimensions using Next Eigenvalue Sufficiency Test}
\usage{
NEST(
  data,
  sample_size,
  iterations = 1000,
  maximum_iterations = 500,
  alpha = 0.05,
  convergence = 0.00001
)
}
\arguments{
\item{data}{Matrix or data frame.
Either a dataset with all numeric values
(rows = cases, columns = variables) or
a symmetric correlation matrix}

\item{sample_size}{Numeric (length = 1).
If input into \code{data} is a correlation matrix,
then specifying the sample size is required}

\item{iterations}{Numeric (length = 1).
Number of iterations to estimate rank.
Defaults to \code{1000}}

\item{maximum_iterations}{Numeric (length = 1).
Maximum umber of iterations to obtain convergence
of eigenvalues.
Defaults to \code{500}}

\item{alpha}{Numeric (length = 1).
Significance level for determine sufficient eigenvalues.
Defaults to \code{0.05}}

\item{convergence}{Numeric (length = 1).
Value necessary to be less than or equal to
when establishing convergence of eigenvalues}
}
\value{
Returns a list containing:

\item{dimensions}{Number of dimensions identified}

\item{loadings}{Loading matrix}

\item{converged}{Whether estimation converged. If \code{FALSE},
then results are reported from last convergence point. Interpret
results with caution.}
}
\description{
Estimates the number of dimensions in data using NEST (Achim, 2017).
See examples to get started
}
\examples{
# Generate factor data
two_factor <- simulate_factors(
  factors = 2, # factors = 2
  variables = 6, # variables per factor = 6
  loadings = 0.55, # loadings between = 0.45 to 0.65
  cross_loadings = 0.05, # cross-loadings N(0, 0.05)
  correlations = 0.30, # correlation between factors = 0.30
  sample_size = 1000 # number of cases = 1000
)

\dontrun{
# Perform NEST
NEST(two_factor$data)}

}
\references{
Achim, A. (2017).
Testing the number of required dimensions in
exploratory factor analysis.
\emph{The Quantitative Methods for Psychology}, \emph{13}(1), 64–74.

Brandenburg, N., & Papenberg, M. (2022).
Reassessment of innovative methods to determine the number
of factors: A simulation-Based comparison of Exploratory
Graph Analysis and Next Eigenvalue Sufficiency Test.
\emph{Psychological Methods}.
}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com>,
Hudson Golino <hfg9s@virginia.edu>,
Luis Eduardo Garrido <luisgarrido@pucmm.edu>
}
