% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R, R/metrics.R, R/models.R
\name{externalMetric,lcModel,lcModel-method}
\alias{externalMetric,lcModel,lcModel-method}
\alias{externalMetric}
\alias{externalMetric,lcModels,missing-method}
\alias{externalMetric,lcModels,lcModel-method}
\alias{externalMetric,lcModels,lcModels-method}
\alias{externalMetric,list,lcModel-method}
\title{Compute external model metric(s)}
\usage{
\S4method{externalMetric}{lcModel,lcModel}(object, object2, name, ...)

\S4method{externalMetric}{lcModels,missing}(object, object2, name = "adjustedRand")

\S4method{externalMetric}{lcModels,lcModel}(object, object2, name, drop = TRUE)

\S4method{externalMetric}{list,lcModel}(object, object2, name, drop = TRUE)
}
\arguments{
\item{object}{The \code{lcModel}, \code{lcModels}, or \code{list} of \code{lcModel} objects to compute the metrics for.}

\item{object2}{The other \code{lcModel} to compare with.}

\item{name}{The name(s) of the metric(s) to compute.}

\item{...}{Additional arguments.}

\item{drop}{Whether to drop the matrix dimensions in case of a single model output.}
}
\value{
For \code{externalMetric(lcModel, lcModel)}: A \code{numeric} vector of the computed metrics.

A named \code{numeric} vector containing the computed model metrics.

For \code{externalMetric(lcModels)}: A distance matrix of class \link{dist} representing
the pairwise comparisons.

For \code{externalMetric(lcModels, lcModel)}: A named \code{numeric} vector or \code{matrix}
containing the computed model metrics.

For \code{externalMetric(list, lcModel)}: A named \code{numeric} vector or \code{matrix}
containing the computed model metrics.
}
\description{
Compute external model metric(s)
}
\examples{
data(latrendData)
model1 <- latrend(lcMethodKML("Y", id = "Id", time = "Time"), latrendData)
model2 <- latrend(lcMethodLcmmGMM(Y ~ Time + (1 | Id), id = "Id", time = "Time"), latrendData)
ari <- externalMetric(model1, model2, 'adjustedRand')
}
\seealso{
\link{metric}

Other metric functions: 
\code{\link{defineExternalMetric}()},
\code{\link{defineInternalMetric}()},
\code{\link{getExternalMetricDefinition}()},
\code{\link{getExternalMetricNames}()},
\code{\link{getInternalMetricDefinition}()},
\code{\link{getInternalMetricNames}()},
\code{\link{metric}()}
}
\concept{metric functions}
