% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{formula.lcMethod}
\alias{formula.lcMethod}
\title{Extract formula}
\usage{
\method{formula}{lcMethod}(x, what = "mu", envir = NULL, ...)
}
\arguments{
\item{x}{The \code{lcMethod} object.}

\item{what}{The distributional parameter to which this formula applies. By default, the formula specifies \code{"mu"}.}

\item{envir}{The \code{environment} in which to evaluate the arguments. If \code{NULL}, the environment associated with the object is used. If not available, the \code{parent.frame()} is used.}

\item{...}{Additional arguments.}
}
\value{
The \code{formula} for the given distributional parameter.
}
\description{
Extracts the associated \code{formula} for the given distributional parameter.
}
\examples{
m <- lcMethodMixtoolsGMM(formula = Y ~ Time + (1 | Id))
formula(m) # Y ~ Time + (1 | Id)
}
\seealso{
Other lcMethod functions: 
\code{\link{[[,lcMethod-method}},
\code{\link{as.data.frame.lcMethods}()},
\code{\link{as.data.frame.lcMethod}()},
\code{\link{as.lcMethods}()},
\code{\link{as.list.lcMethod}()},
\code{\link{evaluate.lcMethod}()},
\code{\link{lcMethod-class}},
\code{\link{update.lcMethod}()}
}
\concept{lcMethod functions}
