% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{package}
\name{latrend-package}
\alias{latrend-package}
\alias{_PACKAGE}
\title{latrend: A Framework for Clustering Longitudinal Data}
\description{
A framework for clustering longitudinal datasets in a standardized way. Provides an interface to existing R packages for clustering longitudinal univariate trajectories, facilitating reproducible and transparent analyses. Additionally, standard tools are provided to support cluster analyses, including repeated estimation, model validation, and model assessment. The interface enables users to compare results between methods, and to implement and evaluate new methods with ease.
}
\section{Getting started}{

\itemize{
\item See \code{vignette("demo", package = "latrend")} for an introduction to conducting a longitudinal cluster analysis on a example case study.
\item See \code{vignette("custom", package = "latrend")} for examples on constructing your own cluster models.
\item See \code{vignette("validation", package = "latrend")} for examples on applying internal cluster validation.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/philips-software/latrend}
  \item Report bugs at \url{https://github.com/philips-software/latrend/issues}
}

}
\author{
\strong{Maintainer}: Niek Den Teuling \email{niek.den.teuling@philips.com} (\href{https://orcid.org/0000-0003-1026-5080}{ORCID})

Other contributors:
\itemize{
  \item Steffen Pauws \email{s.c.pauws@uvt.nl} [contributor]
  \item Edwin van den Heuvel \email{e.r.v.d.heuvel@tue.nl} [contributor]
  \item Copyright © 2021 Koninklijke Philips N.V. [copyright holder]
}

}
