% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{trajectoryAssignments}
\alias{trajectoryAssignments}
\alias{trajectoryAssignments,lcModel-method}
\title{Get the cluster membership of each trajectory}
\usage{
\S4method{trajectoryAssignments}{lcModel}(object, strategy = which.max, ...)
}
\arguments{
\item{object}{The \code{lcModel} to obtain the cluster assignments from.}

\item{strategy}{A function returning the cluster index based on the given vector of membership probabilities. By default, ids are assigned to the cluster with the highest probability.}

\item{...}{Any additional arguments passed to the strategy function.}
}
\description{
Get the cluster membership of each trajectory
}
\details{
While the default strategy is \link{which.max}, it is recommended to use \link[nnet]{which.is.max} instead, as this function breaks ties randomly.
Another strategy to consider is the function \link{which.weight}, which enables weighted sampling of cluster assignments.
}
\examples{
data(latrendData)
model <- latrend(method = lcMethodKML("Y", id = "Id", time = "Time"), latrendData)
trajectoryAssignments(model)

# assign ids at random using weighted sampling
trajectoryAssignments(model, strategy = which.weight)
}
