% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{as.list.lcMethod}
\alias{as.list.lcMethod}
\title{Extract the method arguments as a list}
\usage{
\method{as.list}{lcMethod}(x, ..., args = names(x), eval = TRUE, expand = FALSE, envir = NULL)
}
\arguments{
\item{x}{The \code{lcMethod} object.}

\item{...}{Additional arguments.}

\item{args}{A \verb{character vector} of argument names to select. Only available arguments are returned.
Alternatively, a \code{function} or \code{list} of \code{function}s, whose formal arguments will be selected from the method.}

\item{eval}{Whether to evaluate the arguments.}

\item{expand}{Whether to return all method arguments when \code{"..."} is present among the requested argument names.}

\item{envir}{The \code{environment} in which to evaluate the arguments. If \code{NULL}, the environment associated with the object is used. If not available, the \code{parent.frame()} is used.}
}
\value{
A \code{list} with the argument \code{call}s or evaluated results depending on the value for \code{eval}.
}
\description{
Extract the method arguments as a list
}
\examples{
library(kml)
data(latrendData)
method <- lcMethodKML("Y", id = "Id", time = "Time")
as.list(method)

as.list(method, args = c('id', 'time'))

# select arguments used by kml()
as.list(method, args = kml::kml)

# select arguments used by either kml() or parALGO()
as.list(method, args = c(kml::kml, kml::parALGO))
}
\seealso{
Other lcMethod functions: 
\code{\link{[[,lcMethod-method}},
\code{\link{as.data.frame.lcMethods}()},
\code{\link{as.data.frame.lcMethod}()},
\code{\link{as.lcMethods}()},
\code{\link{evaluate.lcMethod}()},
\code{\link{formula.lcMethod}()},
\code{\link{lcMethod-class}},
\code{\link{names,lcMethod-method}},
\code{\link{update.lcMethod}()}
}
\concept{lcMethod functions}
