% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{generateLongData}
\alias{generateLongData}
\title{Generate longitudinal test data}
\usage{
generateLongData(
  sizes = c(40, 60),
  fixed = Value ~ 1 + Time,
  cluster = ~1 + Time,
  random = ~1,
  id = getOption("latrend.id"),
  data = data.frame(Time = seq(0, 1, by = 0.1)),
  fixedCoefs = c(0, 0),
  clusterCoefs = cbind(c(-2, 1), c(2, -1)),
  randomScales = cbind(0.1, 0.1),
  rrandom = rnorm,
  noiseScales = c(0.1, 0.1),
  rnoise = rnorm,
  clusterNames = LETTERS[seq_along(sizes)],
  shuffle = FALSE,
  seed = NULL
)
}
\arguments{
\item{sizes}{Number of strata per cluster.}

\item{fixed}{Fixed effects formula.}

\item{cluster}{Cluster effects formula.}

\item{random}{Random effects formula.}

\item{id}{Name of the strata.}

\item{data}{Data with covariates to use for generation. Stratified data may be specified by adding a grouping column.}

\item{fixedCoefs}{Coefficients matrix for the fixed effects.}

\item{clusterCoefs}{Coefficients matrix for the cluster effects.}

\item{randomScales}{Standard deviations matrix for the size of the variance components (random effects).}

\item{rrandom}{Random sampler for generating the variance components at location 0.}

\item{noiseScales}{Scale of the random noise passed to rnoise. Either scalar or defined per cluster.}

\item{rnoise}{Random sampler for generating noise at location 0 with the respective scale.}

\item{clusterNames}{A \code{character} vector denoting the names of the generated clusters.}

\item{shuffle}{Whether to randomly reorder the strata in which they appear in the data.frame.}

\item{seed}{Optional seed to set for the PRNG. The set PRNG state persists after the function completes.}
}
\description{
Generate longitudinal test data
}
\examples{
longdata <- generateLongData(sizes = c(40, 70), id = "Id",
                            cluster = ~poly(Time, 2, raw = TRUE),
                            clusterCoefs = cbind(c(1, 2, 5), c(-3, 4, .2)))
plotTrajectories(longdata, response = "Value", id = "Id", time = "Time")
}
