% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{predictPostprob}
\alias{predictPostprob}
\alias{predictPostprob,lcModel-method}
\title{lcModel posterior probability prediction}
\usage{
\S4method{predictPostprob}{lcModel}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{The \code{lcModel} to predict the posterior probabilities with.}

\item{newdata}{Optional data frame for which to compute the posterior probability. If omitted, the model training data is used.}

\item{...}{Additional arguments.}
}
\value{
A N-by-K \code{matrix} indicating the posterior probability per trajectory per measurement on each row, for each cluster (the columns).
Here, \code{N = nrow(newdata)} and \code{K = nClusters(object)}.
}
\description{
Returns the observation-specific posterior probabilities for the given data.
The default implementation returns a uniform probability matrix.
}
\section{Implementation}{

Classes extending \code{lcModel} should override this method to enable posterior probability predictions for new data.
\preformatted{
setMethod("predictPostprob", "lcModelExt", function(object, newdata = NULL, ...) {
  # return observation-specific posterior probability matrix
})
}
}

\seealso{
Other model-specific methods: 
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{lcModel-class}},
\code{\link{logLik.lcModel}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nobs.lcModel}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{time.lcModel}()}
}
\concept{model-specific methods}
