% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{latrendData}
\alias{latrendData}
\title{Artificial longitudinal dataset comprising three classes}
\format{
A \code{data.frame} comprising longitudinal observations from 200 trajectories.
Each row represents the observed value of a trajectory at a specific moment in time.
\describe{
\item{Id}{\code{integer}: The trajectory identifier.}
\item{Time}{\code{numeric}: The measurement time, between 0 and 2.}
\item{Y}{\code{numeric}: The observed value at the respective time \code{Time} for trajectory \code{Id}.}
\item{Class}{\code{factor}: The reference class.}
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{data(latrendData)
head(latrendData)
#>   Id      Time           Y   Class
#> 1  1 0.0000000 -1.08049205 Class 1
#> 2  1 0.2222222 -0.68024151 Class 1
#> 3  1 0.4444444 -0.65148373 Class 1
#> 4  1 0.6666667 -0.39115398 Class 1
#> 5  1 0.8888889 -0.19407876 Class 1
#> 6  1 1.1111111 -0.02991783 Class 1
}\if{html}{\out{</div>}}
}
\source{
This dataset was generated using \link{generateLongData}.
}
\usage{
latrendData
}
\description{
An artificial longitudinal dataset comprising 200 trajectories belonging to one of 3 classes.
Each trajectory deviates in intercept and slope from its respective class trajectory.
}
\examples{
data(latrendData)

if (require("ggplot2")) {
  plotTrajectories(latrendData, id = "Id", time = "Time", response = "Y")

  # plot according to the reference class
  plotTrajectories(latrendData, id = "Id", time = "Time", response = "Y", cluster = "Class")
}
}
\seealso{
\link{latrend-data} \link{generateLongData}
}
\keyword{datasets}
