% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodeFilling.R
\name{nodeFilling}
\alias{nodeFilling}
\title{Produces a grid of locations inside the region boundary.}
\usage{
nodeFilling(poly, node_spacing, hole_list = NULL)
}
\arguments{
\item{poly}{A matrix that contains the vertices of the 
bounding polygon.}

\item{node_spacing}{The distance between grid locations.}

\item{hole_list}{Optional list of holes to be removed from 
the region}

\item{\dots}{Arguments for the plot produced as a side effect.}
}
\value{
An object of type nodeFillingOutput is produced.
\itemize{
  \item EW_locs EW coordinates for the contour plot.
  \item NS_locs NS coordinates for the contour plot.
  \item nodes Matrix of node locations.
  \item poly Matrix of vertices of boundary polygon.
  \item node_spacing Vertical and horizontal node spacing.
  \item hole_list List of polygons representing holes in region.}
}
\description{
nodeFilling produces a grid of locations that are the nodes 
in the diffusion process.
}
\details{
nodeFilling superimposes a square grid 
of points over the region, with spacing given 
by the parameter node_spacing. The points 
contained in the region are retained. The output, 
a nodeFillingOutput object, contains the boundaries 
of the region (and holes), the set of nodes, and EW
and NS coordinates necessary for creating a contour plot.
}
\examples{
plot.new()
data(polygon1)
nodeFillingOutput <- nodeFilling(poly=polygon1,node_spacing=0.02)
plot(nodeFillingOutput)
formLatticeOutput <- formLattice(nodeFillingOutput)
plot(formLatticeOutput)

}
\references{
Ronald P. Barry, Julie McIntyre. Estimating 
animal densities and home range in regions with irregular 
boundaries and holes: A lattice-based alternative to the 
kernel density estimator. Ecological Modelling 222 (2011) 
1666-1672.
}
\author{
Ronald P. Barry
}
