% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/homerange.R
\name{homerange}
\alias{homerange}
\title{Produces a homerange map.}
\usage{
homerange(densityOut, percent = 0.95, output = FALSE)
}
\arguments{
\item{densityOut}{A densityOut object, produced by createDensity.}

\item{percent}{the sum of the probabilities of all 
nodes in the homerange exceeds this value.}

\item{output}{if TRUE, the function returns a matrix 
containing, for each node, a location (first two columns) 
and whether the node is in the homerange.}
}
\description{
homerange produces a map of the homerange, 
for any given percentage. The homerange 
contains the smallest number of nodes with 
total density greater than the percent. This 
function is illustrated in Barry and McIntyre (2011).
}
\examples{
    plot.new()
data(polygon1)
nodeFillingOutput <- nodeFilling(poly=polygon1, node_spacing=0.015)
plot(nodeFillingOutput)
formLatticeOutput <- formLattice(nodeFillingOutput)
plot(formLatticeOutput)
Pointdata <- splancs::csr(polygon1,75)
Pointdata <- Pointdata[Pointdata[,1]<0.5,]
plot(polygon1,type="n")
polygon(polygon1)
points(Pointdata,pch=19)
out <- crossvalDensity(formLatticeOutput,PointPattern=Pointdata,
                      M=0.5,max_steps = 40)
densityOut <- createDensity(formLatticeOutput,PointPattern=Pointdata,
k=out$k,intensity=FALSE, sparse = TRUE)
plot(densityOut)
homerange(densityOut, percent = 0.95)

}
\references{
Ronald P. Barry, Julie McIntyre. Estimating 
animal densities and home range in regions 
with irregular boundaries and holes: A lattice-based 
alternative to the kernel density estimator. 
Ecological Modelling 222 (2011) 1666-1672.
}
\author{
Ronald P. Barry
}
