% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_on_surface.R
\name{lawn_point_on_feature}
\alias{lawn_point_on_feature}
\title{Get a point on the surface of a feature}
\usage{
lawn_point_on_feature(x, lint = FALSE)
}
\arguments{
\item{x}{Any \link{data-GeoJSON} object}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
A \link{data-Feature}<(\link{data-Point})> on the surface of \code{x}
}
\description{
Finds a \link{data-Point} guaranteed to be on the surface of
\link{data-GeoJSON} object.
}
\details{
What will be returned?
\itemize{
\item Given a \link{data-Polygon}, the point will be in the area
of the polygon
\item Given a \link{data-LineString}, the point will be along
the string
\item Given a \link{data-Point}, the point will be the same as
the input
}
}
\examples{
# polygon
x <- lawn_random("polygons")
lawn_point_on_feature(x)
# point
x <- lawn_random("points")
lawn_point_on_feature(x)
# linestring
linestring <- '[
   [-21.929054, 64.127985],
   [-21.912918, 64.134726],
   [-21.916007, 64.141016],
   [-21.930084, 64.14446]
]'
lawn_point_on_feature(lawn_linestring(linestring))
}
\seealso{
Other measurements: 
\code{\link{lawn_along}()},
\code{\link{lawn_area}()},
\code{\link{lawn_bbox_polygon}()},
\code{\link{lawn_bbox}()},
\code{\link{lawn_bearing}()},
\code{\link{lawn_center_of_mass}()},
\code{\link{lawn_center}()},
\code{\link{lawn_centroid}()},
\code{\link{lawn_destination}()},
\code{\link{lawn_distance}()},
\code{\link{lawn_envelope}()},
\code{\link{lawn_extent}()},
\code{\link{lawn_line_distance}()},
\code{\link{lawn_midpoint}()},
\code{\link{lawn_pt2line_distance}()},
\code{\link{lawn_square}()}
}
\concept{measurements}
