% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_array.R
\name{create_lazyarray}
\alias{create_lazyarray}
\title{Create a lazy-array with given format and dimension}
\usage{
create_lazyarray(
  path,
  storage_format,
  dim,
  dimnames = NULL,
  multipart = TRUE,
  prefix = "",
  multipart_mode = 1,
  compress_level = 50L,
  meta_name = "lazyarray.meta"
)
}
\arguments{
\item{path}{path to a local drive to store array data}

\item{storage_format}{data type, choices are \code{"double"}, 
\code{"integer"}, \code{"character"}, and \code{"complex"}}

\item{dim}{integer vector, dimension of array, see \code{\link{dim}}}

\item{dimnames}{list of vectors, names of each dimension, see \code{\link{dimnames}}}

\item{multipart}{whether to split array into multiple partitions, default is true}

\item{prefix}{character prefix of array partition}

\item{multipart_mode}{1, or 2, mode of partition, see details.}

\item{compress_level}{0 to 100, level of compression. 0 means
no compression, 100 means maximum compression. For persistent data,
it's recommended to set 100. Default is 50.}

\item{meta_name}{header file name, default is \code{"lazyarray.meta"}}
}
\value{
A \code{LazyArray} object
}
\description{
Create a directory to store lazy-array. The path must be missing. See \code{\link{load_lazyarray}} for more details
}
\details{
Lazy array stores array into hard drive, and load them on
demand. It differs from other packages such as \code{"bigmemory"}
that the internal reading uses multi-thread, which gains significant 
speed boost on solid state drives. 

One lazy array contains two parts: data file(s) and a meta file.
The data files can be stored in two ways: non-partitioned and 
partitioned. 

For non-partitioned data array, the dimension is 
set at the creation of the array and cannot be mutable once created

For partitioned data array, there are also two partition modes, 
defined by \code{`multipart_mode`}. For mode 1, each partition 
has the same dimension size as the array, with the last dimension
to be one. For example, a data with dimension \code{c(2,3,5)} 
partitioned with mode 1 will have each partition dimension stored
with \code{c(2,3,1)}. For mode 2, the last dimension will be dropped
when storing each partitions.
}
\author{
Zhengjia Wang
}
