# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Applying the Lazy-Greedy Algorithm
#'
#' Function \code{lazyGreedy} is an R wrapper for an efficient C++ implementation of the Lazy-Greedy spanning algorithm. The C++ implementation executes many thousands of times faster than a pure R implementation. Both the algorithm and (most of) the C++ implementation were developed by Quirijn W. Bouts, Alex P. ten Brink, and Kevin Buchin.
#'
#' @param V a numeric \eqn{n}-by-2 matrix the \eqn{i}th row of which contains the location in \eqn{R^2} of vertex \eqn{i}.
#' @param t the desired dilation, a positive real number.
#' @return Function \code{lazyGreedy} returns a greedy \eqn{t}-spanner for the set of vertices \code{V}. The result takes the form of an edge list.
#' @references
#' Bouts, Q. W., ten Brink, A. P., and Buchin, K. (2014). A framework for computing the greedy spanner. In \emph{30th ACM Symposium on Computational Geometry} (SoCG, Kyoto, Japan, June 8-11, 2014) (pp. 11-19). Association for Computing Machinery, Inc.
#' @examples
#' n = 20
#' V = cbind(runif(n), runif(n))
#' spanner = lazyGreedy(V, t = 2)
#'
#' \dontrun{
#' require("network")
#' G = network(spanner, directed = FALSE)
#' plot(G, coord = V, label = 1:n, jitter = FALSE)
#' }
#' @export
lazyGreedy <- function(V, t) {
    .Call(`_lazygreedy_lazyGreedy`, V, t)
}

