% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{import_data}
\alias{import_data}
\title{Import Data file with Trade Logs to R.}
\usage{
import_data(path_sbxm, trade_log_file)
}
\arguments{
\item{path_sbxm}{- String, Path to the sandbox with the log file where the file with data is written}

\item{trade_log_file}{- String, File name where the order results are written}
}
\value{
Function will return the dataframe with trade data and automatically set proper column types
}
\description{
Function is capable to import file with executed trades log.
Files do not have column headers hence function will take care to name columns as well as to perform relevant cleansing
}
\examples{

library(lazytrade)
library(dplyr)
library(readr)
library(lubridate)

path_sbxm <- normalizePath(tempdir(),winslash = "/")

file.copy(from = system.file("extdata", "OrdersResultsT1.csv", package = "lazytrade"),
          to = file.path(path_sbxm, "OrdersResultsT1.csv"), overwrite = TRUE)

DFT1 <- import_data(path_sbxm = path_sbxm,
                    trade_log_file = "OrdersResultsT1.csv")



}
\author{
(C) 2019, 2020 Vladimir Zhbanko
}
