% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decrypt_mykeys.R
\name{decrypt_mykeys}
\alias{decrypt_mykeys}
\title{Function that decrypt encrypted content}
\usage{
decrypt_mykeys(path_encrypted_content, path_private_key)
}
\arguments{
\item{path_encrypted_content}{- path to the encrypted content of the API key}

\item{path_private_key}{- path to the private RSA key, should be without password}
}
\value{
- a string with decrypted key
}
\description{
Function that decrypt encrypted content
}
\details{
It is possible to generate private/public key pair using R-Studio Project Options Menu.
Alternatively possible to use 'openssl' R package
}
\examples{

library(dplyr)
library(magrittr)
library(openssl)
library(readr)

path_ssh <- normalizePath(tempdir(),winslash = "/")
rsa_keygen() \%>\% write_pem(path = file.path(path_ssh, 'id_api'))
# extract and write your public key
read_key(file = file.path(path_ssh, 'id_api'), password = "") \%>\%
`[[`("pubkey") \%>\% write_pem(path = file.path(path_ssh, 'id_api.pub'))

path_private_key <- file.path(path_ssh, "id_api")
path_public_key <- file.path(path_ssh, "id_api.pub")

#encrypting string 'my_key'...
encrypt_api_key(api_key = 'my_key', enc_name = 'api_key.enc.rds',path_ssh = path_ssh)

#encrypted content
out <- read_rds(file.path(path_ssh, "api_key.enc.rds"))

# Consumer API keys
ConsumerAPIkeys <- decrypt_mykeys(path_encrypted_content = file.path(path_ssh,
                                  'api_key.enc.rds'),
                                  path_private_key = path_private_key)


}
