% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaccardTopics.R
\name{jaccardTopics}
\alias{jaccardTopics}
\title{Pairwise Jaccard Coefficients}
\usage{
jaccardTopics(
  topics,
  limit.rel,
  limit.abs,
  atLeast,
  progress = TRUE,
  pm.backend,
  ncpus
)
}
\arguments{
\item{topics}{[\code{named matrix}]\cr
The counts of vocabularies/words (row wise) in topics (column wise).}

\item{limit.rel}{[0,1]\cr
A relative lower bound limit for which words are taken into account. Those words
are taken as relevant for a topic that have a count higher than \code{limit.rel}
multiplied by the total count of the given topic. Default is \code{1/500}.}

\item{limit.abs}{[\code{integer(1)}]\cr
An absolute lower bound limit for which words are taken into account. All words
are taken as relevant for a topic that have a count higher than \code{limit.abs}.
Default is \code{10}.}

\item{atLeast}{[\code{integer(1)}]\cr
An absolute count of how many words are at least considered as relevant for a topic.
Default is \code{0}.}

\item{progress}{[\code{logical(1)}]\cr
Should a nice progress bar be shown? Turning it off, could lead to significantly
faster calculation. Default is \code{TRUE}.
If \code{pm.backend} is set, parallelization is done and no progress bar will be shown.}

\item{pm.backend}{[\code{character(1)}]\cr
One of "multicore", "socket" or "mpi".
If \code{pm.backend} is set, \code{\link[parallelMap]{parallelStart}} is
called before computation is started and \code{\link[parallelMap]{parallelStop}}
is called after.}

\item{ncpus}{[\code{integer(1)}]\cr
Number of (physical) CPUs to use. If \code{pm.backend} is passes,
default is determined by \code{\link[future]{availableCores}}.}
}
\value{
[\code{named list}] with entries
\describe{
  \item{\code{sims}}{[\code{lower triangular named matrix}] with all pairwise
  jaccard similarities of the given topics.}
  \item{\code{wordslimit}}{[\code{integer}] with counts of words determined as
  relevant based on \code{limit.rel} and \code{limit.abs}.}
  \item{\code{wordsconsidered}}{[\code{integer}] with counts of considered
  words for similarity calculation. Could differ from \code{wordslimit}, if
  \code{atLeast} is greater than zero.}
  \item{\code{param}}{[\code{named list}] with parameter specifications for
  \code{limit.rel} [0,1], \code{limit.abs} [\code{integer(1)}] and
  \code{atLeast} [\code{integer(1)}] See above for explanation.}
}
}
\description{
Calculates the similarity of all pairwise topic combinations using a modified
Jaccard Coefficient.
}
\details{
The modified Jaccard Coefficient \eqn{J_m} is calculated by
\deqn{J_m(\bm z_{i}, \bm z_{j} \mid \bm c) = \frac{\sum_{v = 1}^{V} 1_{\left\{n_{i}^{(v)} > c_i ~\wedge~ n_{j}^{(v)} > c_j\right\}}\left(n_{i}^{(v)}, n_{j}^{(v)}\right)}{\sum_{v = 1}^{V} 1_{\left\{n_{i}^{(v)} > c_i ~\vee~ n_{j}^{(v)} > c_j\right\}}\left(n_{i}^{(v)}, n_{j}^{(v)}\right)}}
with \eqn{V} is the vocabulary size, and \eqn{n_k^{(v)}} is the count of
assignments of the \eqn{v}-th word to the \eqn{k}-th topic. The threshold vector \eqn{\bm c}
is determined by the maximum threshold of the user given lower bounds \code{limit.rel}
and \code{limit.abs}. In addition, at least \code{atLeast} words per topic are
considered for calculation. According to this, if there are less than
\code{atLeast} words considered as relevant after applying \code{limit.rel}
and \code{limit.abs} the \code{atLeast} most common words per topic are taken
to determine topic similarities.

The procedure of determining relevant words is executed for each topic individually.
The values \code{wordslimit} and \code{wordsconsidered} describes the number
of relevant words per topic.
}
\examples{
res = LDARep(docs = reuters_docs, vocab = reuters_vocab, n = 4, K = 10, num.iterations = 30)
topics = mergeTopics(res, vocab = reuters_vocab)
jacc = jaccardTopics(topics, atLeast = 2)
jacc

n1 = getConsideredWords(jacc)
n2 = getRelevantWords(jacc)
(n1 - n2)[n1 - n2 != 0]

sim = getSimilarity(jacc)
dim(sim)

}
\seealso{
Other TopicSimilarity functions: 
\code{\link{dendTopics}()},
\code{\link{getSimilarity}()}

Other workflow functions: 
\code{\link{LDARep}()},
\code{\link{SCLOP}()},
\code{\link{dendTopics}()},
\code{\link{getPrototype}()},
\code{\link{mergeTopics}()}
}
\concept{TopicSimilarity functions}
\concept{workflow functions}
