% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ldamatch.R
\name{ldamatch}
\alias{ldamatch}
\title{Creates a matched group via backward selection.}
\usage{
ldamatch(condition, covariates, halting_test, thresh = 0.2,
  method = c("heuristic", "montecarlo", "exhaustive"), props = NULL,
  replicates = NULL, print_info = get("PRINT_INFO", .ldamatch_globals))
}
\arguments{
\item{condition}{A factor vector containing condition labels.}

\item{covariates}{A vector or columnwise matrix containing
                     covariates to match the conditions on.}

\item{halting_test}{A function to apply to `covariates` (in matrix form)
                     which is TRUE iff the conditions are matched.}

\item{thresh}{The statistical threshold to pass onto the
                     aforementioned test.}

\item{method}{The choice of search method. The "heuristic" method
                     deploys the table of desired proportions
                     (see below) to structure search. The "montecarlo"
                     method randomly generates subspaces of decreasing
                     size. The "exhaustive" considers all possible
                     subsamples and may be very, very slow.}

\item{props}{The desired proportions (percentage) of the sample for
                     each condition; if not specified, the (full)
                     sample proportions are used. This is used
                     for the "heuristic" and "exhaustive" methods.}

\item{replicates}{The maximum number of Monte Carlo replications to be
                     performed. This is only used for the "montecarlo"
                     method.}

\item{print_info}{If TRUE, prints summary information on the input and the
                     results, as well as progress information for the
                     exhaustive search algorithm. Default: TRUE;
                     can be changed using set_param("PRINT_INFO", FALSE).}
}
\value{
A logical vector, TRUE iff row is in the match,
                     or a list of such vectors for the exhaustive search.

The exhaustive search method uses the foreach package to parallelize
computation. To take advantage of this, you must register a cluster.
For example, to use all but one of the CPU cores:
  doMC::registerDoMC(max(1, parallel::detectCores() - 1))
To use sequential processing:
  foreach::registerDoSEQ()
}
\description{
Creates a matched group via backward selection.
}

