% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{Data_Wdi}
\alias{Data_Wdi}
\title{Aggregate WDI Data and create \code{Country-Series} Table}
\usage{
Data_Wdi(
  dirPath,
  minYear = 1960,
  maxYear = 2020,
  aggFunction = function(data, code, name, unit, definition, aggMethod) {
     isPerc <-
    unit == "\%" || grepl(".ZG", code)
     if (isPerc) {
         NA
     }
     else {

            LongrunGrowth(data, 30, 5, FALSE, TRUE, isPerc)
     }
 },
  keepFunction = function(X) {
     var(X, na.rm = TRUE) > 1e-12 && sum((is.na(X)) ==
    FALSE) >= 50
 },
  ...
)
}
\arguments{
\item{dirPath}{(character) path to the data directory in CSV format.
It must have 'WDICountry-Series.csv', 'WDIData.csv', 'WDICountry.csv',
'WDISeries.csv'. Download it from the WDI site.}

\item{minYear}{(integer) a year where aggregation starts}

\item{maxYear}{(integer) a year where aggregation ends.}

\item{aggFunction}{(function) aggregation function, such as:
function(data,code,name,unit,defintion,aggMethod){mean(data, na.rm = TRUE)};
where 'data' is the data-points from \code{minYear} to \code{maxYear},
'unit' is the unit of measurement, 'definition' is the long definition of the series,
'aggMethod' is the method of aggregation.}

\item{keepFunction}{(function) a function to determine how to keep or omit a
series (i.e., column). default function skips growth rates, checks the
variance and the number of non-NA data-points.}

\item{...}{additional arguments}
}
\value{
data, countries information (rows in data), and series information (columns in data)
}
\description{
Aggregate WDI Data and create \code{Country-Series} Table
}
